%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% Matt Fitzgerald
% Space Tug Era simulator    (first multiple-arc attempt)

function [Rev Cost transCost ruleUse utilityMonths bestPareto worstPareto avgPareto avgParetoNoFail metContracts missedContracts] = ERA_spaceTug_maxProfit(initialDesign,eraLength,numRules,rulepathP,rulepathF,costpathP,costpathF,MAU,COSTS,fuzzyParetoNumbers)

numEpochs = size(MAU,2);
numDesigns = size(rulepathP,1);

ruleUse = zeros(1,numRules);
transCost = zeros(1,2);
Rev = 0;
Cost = COSTS(initialDesign,1);
utilityMonths = 0;
paretoPath = [];
currTime = 0;
currDesign = initialDesign;
designPath = currDesign;
epochPath = [];
metContracts = 0;
missedContracts = 0;

% set NaN MAUs to -1 (failure)
MAU(isnan(MAU)) = -1;

% pick random time after 5 years for future technology switch
if eraLength <= 60 % remember, time is in months for this dataset
    futureTime = eraLength;
else
    futureTime = round((eraLength-60)*rand(1)) + 60;
end


while currTime < futureTime
    % pick a random customer (epoch) in present time
    currEpoch = round((numEpochs/2)*rand(1) + .5);
    epochPath = [epochPath currEpoch];
    % pick a random duration for their need from 1 to 12 months
    currDuration = round(rand(1)*12 + .5);
    currTime = currTime + currDuration;
    
    % find available transitions
    available = [];
    for d2 = 1:numDesigns
        if ~isempty(costpathP{currDesign,d2})
            available = [available d2];
        end
    end
   
    % sort available designs by utility
    availableMAU = MAU(available,currEpoch);
    [sortedAvailableMAU index] = sort(availableMAU,'descend');
    sortedAvailable = available(index);
    
    % clip out end states with lower utility than current state
    % (will not result in better profit than choosing to not transition)
    currMAU = MAU(currDesign,currEpoch);
    aboveThresh = sortedAvailableMAU>currMAU;
    sortedAvailableMAU = sortedAvailableMAU(aboveThresh);
    sortedAvailable = sortedAvailable(aboveThresh);
    
    % find no change profit and set as current baseline
    if currMAU >= 0
        bestProfit = 200 + 1000*currDuration*currMAU;
    else
        bestProfit = 0;
    end
    bestTarget = currDesign;
    bestPath = 0;
    
    % iterate through available designs
    for target = sortedAvailable
        targetMAU = MAU(target,currEpoch);
        pathOptions = costpathP{currDesign,target};  % this is a MATRIX output, with rows == # path options
        for i = 1:size(pathOptions,1)
            profitOption = 200 + 1000*(currDuration-pathOptions(i,2))*targetMAU - pathOptions(i,1);
            rulesOption = rulepathP{currDesign,target}{i};
            if any(rulesOption ~= 6)
                profitOption = profitOption - COSTS(target,currEpoch);  % make sure to account for redesign costs
            end
            if profitOption > bestProfit
                bestProfit = profitOption;
                bestTarget = target;
                bestPath = i;
            end
        end
    end
    
    % now we know the best target and the best path to take so
    if bestTarget ~= currDesign
        rulesUsed = rulepathP{currDesign,bestTarget}{bestPath};
        for r = rulesUsed
            ruleUse(1,r) = ruleUse(1,r) + 1;   % INCREMENT RULE USE COUNT
        end
        if any(rulesUsed ~= 6)
            Cost = Cost + COSTS(bestTarget,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
        end
        Cost = Cost + costpathP{currDesign,bestTarget}(bestPath,1);  % ADD IN TRANS $ COST AS WELL
        transCost = transCost + costpathP{currDesign,bestTarget}(bestPath,:); % INCREMENT TRANS COSTS ($/time)
        currDuration = currDuration - costpathP{currDesign,bestTarget}(bestPath,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
        currDesign = bestTarget;  % CHANGE CURRENT DESIGN TO TARGET
        designPath = [designPath currDesign];
    end
    
    % at this point, we have the effective design and duration for this
    % epoch, so we should be able to calculate revenues
    if MAU(currDesign,currEpoch) ~= -1
        Rev = Rev + 200 + 1000*currDuration*MAU(currDesign,currEpoch);  % $200M fixed + $1000M*utility per month
        utilityMonths = utilityMonths + MAU(currDesign,currEpoch)*currDuration;
    end
    % to account for fuel use, downgrade one design number if not at a
    % min fuel design AND was valid for this epoch
    if mod(currDesign,8) ~= 1 && MAU(currDesign,currEpoch) ~= -1
        currDesign = currDesign - 1;
    end
    % add a missed contract if failed
    if MAU(currDesign,currEpoch) == -1
        missedContracts = missedContracts + 1;
    else
        metContracts = metContracts + 1;
    end
    % update pareto path
    paretoPath = [paretoPath fuzzyParetoNumbers(currDesign,currEpoch)];
    
        
end

% do the same loop after future tech threshold
while currTime < eraLength
    % pick a random customer (epoch) in present time
    currEpoch = round((numEpochs/2)*(1+rand(1)) + .5);
    epochPath = [epochPath currEpoch];
    % pick a random duration for their need from 1 to 12 months
    currDuration = round(rand(1)*12 + .5);
    currTime = currTime + currDuration;
    
    % find available transitions
    available = [];
    for d2 = 1:numDesigns
        if ~isempty(costpathF{currDesign,d2})
            available = [available d2];
        end
    end
 
        % sort available designs by utility
    availableMAU = MAU(available,currEpoch);
    [sortedAvailableMAU index] = sort(availableMAU,'descend');
    sortedAvailable = available(index);
    
    % clip out end states with lower utility than current state
    % (will not result in better profit than choosing to not transition)
    currMAU = MAU(currDesign,currEpoch);
    aboveThresh = sortedAvailableMAU>currMAU;
    sortedAvailableMAU = sortedAvailableMAU(aboveThresh);
    sortedAvailable = sortedAvailable(aboveThresh);
    
    % find no change profit and set as current baseline
    if currMAU >= 0
        bestProfit = 200 + 1000*currDuration*currMAU;
    else
        bestProfit = 0;
    end
    bestTarget = currDesign;
    bestPath = 0;
    
    % iterate through available designs
    for target = sortedAvailable
        targetMAU = MAU(target,currEpoch);
        pathOptions = costpathF{currDesign,target};  % this is a MATRIX output, with rows == # path options
        for i = 1:size(pathOptions,1)
            profitOption = 200 + 1000*(currDuration-pathOptions(i,2))*targetMAU - pathOptions(i,1);
            rulesOption = rulepathF{currDesign,target}{i};
            if any(rulesOption ~= 6)
                profitOption = profitOption - COSTS(target,currEpoch);  % make sure to account for redesign costs
            end
            if profitOption > bestProfit
                bestProfit = profitOption;
                bestTarget = target;
                bestPath = i;
            end
        end
    end
    
    % now we know the best target and the best path to take so
    if bestTarget ~= currDesign
        rulesUsed = rulepathF{currDesign,bestTarget}{bestPath};
        for r = rulesUsed
            ruleUse(1,r) = ruleUse(1,r) + 1;   % INCREMENT RULE USE COUNT
        end
        if any(rulesUsed ~= 6)
            Cost = Cost + COSTS(bestTarget,currEpoch);  % ADD REDESIGN/BUILD COST IF A REDESIGN RULE IS USED
        end
        Cost = Cost + costpathF{currDesign,bestTarget}(bestPath,1);  % ADD IN TRANS $ COST AS WELL
        transCost = transCost + costpathF{currDesign,bestTarget}(bestPath,:); % INCREMENT TRANS COSTS ($/time)
        currDuration = currDuration - costpathF{currDesign,bestTarget}(bestPath,2);  % REDUCE REMAINING DURATION OF THIS EPOCH
        currDesign = bestTarget;  % CHANGE CURRENT DESIGN TO TARGET
        designPath = [designPath currDesign];
    end
    
    % at this point, we have the effective design and duration for this
    % epoch, so we should be able to calculate revenues
    if MAU(currDesign,currEpoch) ~= -1
        Rev = Rev + 250 + 1000*currDuration*MAU(currDesign,currEpoch);  % $200M fixed + $1000M*utility per month
        utilityMonths = utilityMonths + MAU(currDesign,currEpoch)*currDuration;
    end
    % to account for fuel use, downgrade one design number if not at a
    % min fuel design AND was valid for this epoch
    if mod(currDesign,8) ~= 1 && MAU(currDesign,currEpoch) ~= -1
        currDesign = currDesign - 1;
    end
    % add a missed contract if failed
    if MAU(currDesign,currEpoch) == -1
        missedContracts = missedContracts + 1;
    else
        metContracts = metContracts + 1;
    end
    % update paretoPath
    paretoPath = [paretoPath fuzzyParetoNumbers(currDesign,currEpoch)];
    
end

% process paretoPath
worstPareto = max(paretoPath);
bestPareto = min(paretoPath);
avgPareto = mean(paretoPath);
avgParetoNoFail = mean(paretoPath(paretoPath ~= 101));

end